/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.WebViewEvent;
import apiipc.generated.events.WebViewEventListener;
import apiipc.generated.ui.WebView;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebViewEventRegistry
extends IPCEventRegistry {
    protected Set<WebViewEventListener> globalListeners = new HashSet<WebViewEventListener>();
    protected Map<String, Set<WebViewEventListener>> specificObjectListeners = new HashMap<String, Set<WebViewEventListener>>();

    public WebViewEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "WebView";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        WebViewEvent.Closed closed = null;
        if (!string.equalsIgnoreCase("closed")) {
            return;
        }
        closed = new WebViewEvent.Closed(iPCEventLTV);
        for (WebViewEventListener object : this.globalListeners) {
            object.handleEvent(closed);
        }
        Set<WebViewEventListener> set = this.specificObjectListeners.get(closed.objectUUID.toString());
        if (set != null) {
            for (WebViewEventListener webViewEventListener : set) {
                webViewEventListener.handleEvent(closed);
            }
        }
    }

    public void addListenerFiltered(WebViewEventListener webViewEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("closed");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(webViewEventListener);
    }

    public void addSpecificListenerFiltered(WebViewEventListener webViewEventListener, WebView webView, List<String> list) throws IOException {
        UUID uUID = webView.getObjectUUID();
        String string = uUID.toString();
        Set<WebViewEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<WebViewEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "closed");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(webViewEventListener);
    }

    public void removeListenerFiltered(WebViewEventListener webViewEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("closed");
            }
            this.globalListeners.remove(webViewEventListener);
        }
    }

    public void removeSpecificListenerFiltered(WebViewEventListener webViewEventListener, WebView webView, List<String> list) throws IOException {
        UUID uUID = webView.getObjectUUID();
        String string = uUID.toString();
        Set<WebViewEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "closed");
            set.remove(webViewEventListener);
        }
    }

    public void addListener(WebViewEventListener webViewEventListener) throws IOException {
        this.addListenerFiltered(webViewEventListener, null);
    }

    public void addListener(WebViewEventListener webViewEventListener, WebView webView) throws IOException {
        this.addSpecificListenerFiltered(webViewEventListener, webView, null);
    }

    public void removeListener(WebViewEventListener webViewEventListener) throws IOException {
        this.removeListenerFiltered(webViewEventListener, null);
    }

    public void removeListener(WebViewEventListener webViewEventListener, WebView webView) throws IOException {
        this.removeSpecificListenerFiltered(webViewEventListener, webView, null);
    }
}

